unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Contnrs, StdCtrls;

type
  TPessoa = class
  private
    FNome: String;
    FIdade: Integer;
    FProfissao: String;
  public
    property Nome: String read FNome write FNome;
    property Idade: Integer read FIdade write FIdade;
    property Profissao: String read FProfissao write FProfissao;
  end;
  
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    memObjetosPilha: TMemo;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    memObjetosFila: TMemo;
    Label3: TLabel;
    Label4: TLabel;
    edtIdadePilha: TEdit;
    edtNomePilha: TEdit;
    Label5: TLabel;
    edtProfissaoPilha: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    edtIdadeFila: TEdit;
    edtNomeFila: TEdit;
    Label8: TLabel;
    edtProfissaoFila: TEdit;
    btnInserirPilha: TButton;
    btnSalvarPilha: TButton;
    btnInserirFila: TButton;
    btnSalvarFila: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnInserirPilhaClick(Sender: TObject);
    procedure btnSalvarPilhaClick(Sender: TObject);
    procedure edtProfissaoPilhaChange(Sender: TObject);
    procedure btnInserirFilaClick(Sender: TObject);
    procedure btnSalvarFilaClick(Sender: TObject);
    procedure edtProfissaoFilaChange(Sender: TObject);
  private
    FStackPessoa: TObjectStack;
    FQueuePessoa: TObjectQueue;
    FPessoa: TPessoa;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  // instanciando as Listas de Pilha e Fila, respectivamente.
  FStackPessoa := TObjectStack.Create;
  FQueuePessoa := TObjectQueue.Create;
end;

procedure TForm1.btnInserirPilhaClick(Sender: TObject);
begin
  edtNomePilha.Text := EmptyStr;
  edtIdadePilha.Text := EmptyStr;
  edtProfissaoPilha.Text := EmptyStr;
  // seta o foco para o Edit de Nome.
  edtNomePilha.SetFocus;
end;

procedure TForm1.btnSalvarPilhaClick(Sender: TObject);
var
  FStackTemp: TObjectStack;
  inCount: Integer;
begin
  // Instancia um novo objeto TPessoa.
  FPessoa := TPessoa.Create;
  // recebe os valores informados.
  FPessoa.Nome := edtNomePilha.Text;
  FPessoa.Idade := StrToInt(edtIdadePilha.Text);
  FPessoa.Profissao := edtProfissaoPilha.Text;
  // armazena na Pilha o novo Objeto.
  FStackPessoa.Push(FPessoa);
  // Instancia um objeto de Pilha auxiliar.
  FStackTemp := TObjectStack.Create;
  // inicializa o contador de Objetos da Pilha.
  inCount := 1;
  // limpa o Memo.
  memObjetosPilha.Clear;

  // enquanto houver Objetos na Pilha de Pessoa ...
  while FStackPessoa.Count > 0 do
  begin
    // insere os dados do Objeto inserido na Pilha, no memo.
    memObjetosPilha.Lines.Add('Objeto N.: ' + IntToStr(inCount));
    memObjetosPilha.Lines.Add(TPessoa(FStackPessoa.Peek).Nome);
    memObjetosPilha.Lines.Add(IntToStr(TPessoa(FStackPessoa.Peek).Idade));
    memObjetosPilha.Lines.Add(TPessoa(FStackPessoa.Peek).Profissao);
    memObjetosPilha.Lines.Add(EmptyStr);
    Inc(inCount, 1);
    // retira o Objeto da Pilha de Pessoa e o Insere
    // na Pilha temporria.
    FStackTemp.Push(FStackPessoa.Pop);
  end;//while..do.

  // enquanto existir Objetos na Pilha temporria...
  while FStackTemp.Count > 0 do
    // o que estamos fazendo  apenas restaurando a Pilha
    // de Objetos Pessoa, retirando os Objetos da Pilha temporria
    // para a Pilha de Origem.
    FStackPessoa.Push(FStackTemp.Pop);
  // Desabilita o Boto de Salvar.
  btnSalvarPilha.Enabled := False;
end;

procedure TForm1.edtProfissaoPilhaChange(Sender: TObject);
begin
  // somente habilita o Boto informarem os respectivos valores dos campos.
  btnSalvarPilha.Enabled := (edtNomePilha.Text <> EmptyStr) and
                            (edtIdadePilha.Text <> EmptyStr) and
                            (edtProfissaoPilha.Text <> EmptyStr);
end;

procedure TForm1.btnInserirFilaClick(Sender: TObject);
begin
  edtNomeFila.Text := EmptyStr;
  edtIdadeFila.Text := EmptyStr;
  edtProfissaoFila.Text := EmptyStr;
  // seta o foco para o Edit de Nome.
  edtNomeFila.SetFocus;
end;

procedure TForm1.btnSalvarFilaClick(Sender: TObject);
var
  FQueueTemp: TObjectQueue;
  inCount: Integer;
begin
  // Instancia um novo objeto TPessoa.
  FPessoa := TPessoa.Create;
  // recebe os valores informados.
  FPessoa.Nome := edtNomeFila.Text;
  FPessoa.Idade := StrToInt(edtIdadeFila.Text);
  FPessoa.Profissao := edtProfissaoFila.Text;
  // armazena na Fila o novo Objeto.
  FQueuePessoa.Push(FPessoa);
  // Instancia um Objeto de Fila temporrio.
  FQueueTemp := TObjectQueue.Create;
  // limpa o Memo.
  memObjetosFila.Clear;

  // enquanto houver Objetos na Pilha de Pessoa ...
  for inCount := 0 to FQueuePessoa.Count - 1 do
  begin
    // insere os dados do Objeto inserido na Fila, no memo.
    memObjetosFila.Lines.Add('Objeto N.: ' + IntToStr(inCount + 1));
    memObjetosFila.Lines.Add(TPessoa(FQueuePessoa.Peek).Nome);
    memObjetosFila.Lines.Add(IntToStr(TPessoa(FQueuePessoa.Peek).Idade));
    memObjetosFila.Lines.Add(TPessoa(FQueuePessoa.Peek).Profissao);
    memObjetosFila.Lines.Add(EmptyStr);
    // armazenando o Objeto da Fila em um objeto de Fila temporrio.
    FQueueTemp.Push(FQueuePessoa.Pop);
  end;//for..do.

  // percorre todos os objetos da fila temporria.
  for inCount := 0 to FQueueTemp.Count - 1 do
    // restaura os objetos da fila temporria para a fila de origem.
    FQueuePessoa.Push(FQueueTemp.Pop);

  // Desabilita o Boto de Salvar.
  btnSalvarFila.Enabled := False;
end;

procedure TForm1.edtProfissaoFilaChange(Sender: TObject);
begin
  // somente habilita o Boto informarem os respectivos valores dos campos.
  btnSalvarFila.Enabled := (edtNomeFila.Text <> EmptyStr) and
                           (edtIdadeFila.Text <> EmptyStr) and
                           (edtProfissaoFila.Text <> EmptyStr);
end;

end.
